// 客户端请求
var userAgent = window.navigator.userAgent
var WebViewJavascriptBridge
console.log(userAgent)

// 判断设备信息
function isIOS() {
	if (userAgent.indexOf('Mac OS X') > -1) {
		return true
	}
}
function isAndroid() {
	if (userAgent.indexOf('Android') > -1) {
		return true
	}
}
function isApp(){
  if(userAgent.includes('szd_SZGov')){
    return true;
  }
  else{
    return false;
  }
}

if (isIOS()) {
	function setupWebViewJavascriptBridge(callback) {
		if (window.WebViewJavascriptBridge) { return callback(WebViewJavascriptBridge); }
		if (window.WVJBCallbacks) { return window.WVJBCallbacks.push(callback); }
		window.WVJBCallbacks = [callback]; // 创建一个 WVJBCallbacks 全局属性数组，并将 callback 插入到数组中。
		var WVJBIframe = document.createElement('iframe'); // 创建一个 iframe 元素
		WVJBIframe.style.display = 'none'; // 不显示
		WVJBIframe.src = 'wvjbscheme://__BRIDGE_LOADED__'; // 设置 iframe 的 src 属性
		document.documentElement.appendChild(WVJBIframe); // 把 iframe 添加到当前文导航上。
		setTimeout(function () { document.documentElement.removeChild(WVJBIframe) }, 0)
	}

	// 这里主要是注册 OC 将要调用的 JS 方法。
	setupWebViewJavascriptBridge(function (bridge) {
    bridge.registerHandler('getTokenSuccess', function (res) {
			window.getTokenSuccess(res)
    });
		bridge.registerHandler('getNewTokenSuccess', function (res) {
			window.getNewTokenSuccess(res)
    });
    bridge.registerHandler('getPosition', function(res) {
      window.getPosition(res)
    });
    bridge.registerHandler('getPositionForce', function(res) {
      window.getPositionForce(res)
    });
    bridge.registerHandler('scanSuccess', function(res) {
      window.scanSuccess(res)
    });
    bridge.registerHandler('getTokenRawSuccess', function (res) {
			window.getTokenRawSuccess(res)
    });
		bridge.registerHandler('getNewTokenRawSuccess', function (res) {
			window.getNewTokenRawSuccess(res)
    });
    bridge.registerHandler('loginsuccess', function(res) {
      window.loginsuccess(res)
    });
    bridge.registerHandler('enableBackSuccess', function(res) {
      window.enableBackSuccess(res)
    });
    bridge.registerHandler('h5PostResponse', function(res) {
      window.h5PostResponse(res)
    });
    bridge.registerHandler('h5GetResponse', function(res) {
      window.h5GetResponse(res)
    });
    bridge.registerHandler('onPageInvisible', function(res) {
      window.onPageInvisible(res)
    });
    bridge.registerHandler('onPageReVisible', function(res) {
      window.onPageReVisible(res)
    });
	});
}

// 注册JS调用原生方法
function getToken() {
  if (isIOS()) {
    WebViewJavascriptBridge && WebViewJavascriptBridge.callHandler('getToken',{getToken: 'getTokenSuccess'})
  } else {
    window.SzdUserInfoJsbridge && window.SzdUserInfoJsbridge.getToken('getTokenSuccess')
  }
}
function getNewToken() {
  if (isIOS()) {
    WebViewJavascriptBridge && WebViewJavascriptBridge.callHandler('getNewToken',{getNewToken: 'getNewTokenSuccess'})
  } else {
    window.SzdUserInfoJsbridge && window.SzdUserInfoJsbridge.getNewToken('getNewTokenSuccess')
  }
}
function getNativeLocation() {
  if (isIOS()) {
    WebViewJavascriptBridge && WebViewJavascriptBridge.callHandler('startLocate', {startLocate: 'getPosition'})
  } else {
    window.CommonJsbridge && window.CommonJsbridge.startLocate('getPosition')
  }
}
function getNativeForce() {
  if (isIOS()) {
    WebViewJavascriptBridge && WebViewJavascriptBridge.callHandler('startForceLocateForGcj02', {startForceLocateForGcj02: 'getPositionForce'})
  } else {
    window.CommonJsbridge && window.CommonJsbridge.startForceLocateForGcj02('getPositionForce')
  }
}
function openPage(pageRoute, pageParams){
  if (isIOS()) {
    WebViewJavascriptBridge && WebViewJavascriptBridge.callHandler('openPage', { pageRoute, pageParams })
  } else {
    window.CommonJsbridge && window.CommonJsbridge.openPage(pageRoute,pageParams)
  }
}
function openScanner() {
  if (isIOS()) {
    WebViewJavascriptBridge && WebViewJavascriptBridge.callHandler('openScanner', {openScanner: 'scanSuccess'})
  } else {
    window.CommonJsbridge && window.CommonJsbridge.openScanner('scanSuccess')
  }
}
function openBrowser(url) {
  if (isIOS()) {
    WebViewJavascriptBridge && WebViewJavascriptBridge.callHandler('openBrowser', {openBrowser: url})
  } else {
    window.CommonJsbridge && window.CommonJsbridge.openBrowser(url)
  }
}
function getTokenRaw() {
  if (isIOS()) {
    WebViewJavascriptBridge && WebViewJavascriptBridge.callHandler('getTokenRaw',{getTokenRaw: 'getTokenRawSuccess'})
  } else {
    window.SzdUserInfoJsbridge && window.SzdUserInfoJsbridge.getTokenRaw('getTokenRawSuccess')
  }
}
function getNewTokenRaw() {
  if (isIOS()) {
    WebViewJavascriptBridge && WebViewJavascriptBridge.callHandler('getNewTokenRaw',{getNewTokenRaw: 'getNewTokenRawSuccess'})
  } else {
    window.SzdUserInfoJsbridge && window.SzdUserInfoJsbridge.getNewTokenRaw('getNewTokenRawSuccess')
  }
}
function closeWindow() {
  if (isIOS()) {
    WebViewJavascriptBridge && WebViewJavascriptBridge.callHandler('closeWindow')
  } else {
    window.CommonJsbridge && window.CommonJsbridge.closeWindow()
  }
}
function getUserInfo (callBack) {
  if (isIOS()) {
    WebViewJavascriptBridge && WebViewJavascriptBridge.callHandler('getUserInfo', function (res) {
      callBack(res)
    })
  } else {
    window.CommonJsbridge && callBack(window.CommonJsbridge.getUserInfo())
  }
}
function nativeLogin() {
  if (isIOS()) {
    WebViewJavascriptBridge && WebViewJavascriptBridge.callHandler('nativeLogin',{nativeLogin: 'loginsuccess'})
  } else {
    window.CommonJsbridge && window.CommonJsbridge.nativeLogin('loginsuccess')
  }
}
function getNativeInfo (callBack) {
  if (isIOS()) {
    return WebViewJavascriptBridge && WebViewJavascriptBridge.callHandler('getNativeInfo', function (res) {
      callBack(res)
    })
  } else {
    return window.CommonJsbridge && callBack(window.CommonJsbridge.getNativeInfo())
  }
}
function enableBack() {
  if (isIOS()) {
    WebViewJavascriptBridge && WebViewJavascriptBridge.callHandler('enableInterceptBackPressed',{enableInterceptBackPressed: 'enableBackSuccess'})
  } else {
    window.CommonJsbridge && window.CommonJsbridge.enableInterceptBackPressed('enableBackSuccess')
  }
}
function disableBack() {
  if (isIOS()) {
    WebViewJavascriptBridge && WebViewJavascriptBridge.callHandler('disableInterceptBackPressed')
  } else {
    window.CommonJsbridge && window.CommonJsbridge.disableInterceptBackPressed()
  }
}

function toast(info) {
  if (isIOS()) {
    WebViewJavascriptBridge &&  WebViewJavascriptBridge.callHandler('toast', info)
  } else {
    window.CommonJsbridge && window.CommonJsbridge.toast(info)
  }
}
function gotoOauth(appid,scope,pageName,pageImg,pageUrl) {
  let urlLink = 'https://szdh5test.suzhou.gov.cn/#'+'/authorization/auth?'+"appid="+appid+"&scope="+scope+'&pageName='+pageName+'&pageImg='+pageImg+'&pageUrl'+pageUrl;
  if (isIOS()) {
    location.replace(urlLink);
  } else {
    let path = window.location.hostname;
    let url = urlLink
    console.log(path);
    if (url.indexOf(path) == -1) {
      location.replace(url);
    } else {
      history.replaceState(null, null, url);
      history.go(-1);
      location.href = url;
    }
  }

}
/**
 * 原生请求
 * @param {*} id 
 * @param {*} url 
 */
function nativeGetRquest(id, url) {
  if (isIOS()) {
    WebViewJavascriptBridge && WebViewJavascriptBridge.callHandler('nativeGetRquest', {id: id, url: url})
  } else {
    window.CommonJsbridge && window.CommonJsbridge.nativeGetRquest(id, url)
  }
}
function nativePostRquest(id, url, params) {
  if (isIOS()) {
    WebViewJavascriptBridge && WebViewJavascriptBridge.callHandler('nativePostRquest', {id: id, url: url, params: JSON.stringify(params)})
  } else {
    window.CommonJsbridge && window.CommonJsbridge.nativePostRquest(id, url, JSON.stringify(params))
  }
}





// 客户端响应
var resData = {}
// get请求
function h5GetResponse(res) {
  handleData(res)
}
//post请求
function h5PostResponse(res){
  handleData(res)
}
function handleData(res) {
  let json = res.indexOf('{') > -1 && JSON.parse(res)
  if (JSON.stringify(json.res).indexOf('{') === -1) {
    resData[json.callId] = json.res
    return
  }
  json.res = JSON.parse(json.res)
  resData[json.callId] = json.res
}
//获取最终数据
function dispatch(request) {
  return new Promise(resolve => {
    Object.defineProperty(resData, request, {
      set: function (data) {
        resolve(data)
      }
    })
  })
}

//页面回调
function onPageInvisible(){
  console.log('离开页面');
}
function onPageReVisible(){
  console.log('进入页面');
}